//***************************************************************************************************************
//
//  Sample Program for LCD Cursor
//
//  Target Machine : CPT-711
//
//  Function:
//  void SetCursor(int status)                  : Turn on or off the cursor of the LCD display. (0:off, 1:on)
//  int  GetCursor(void)                        : Get current cursor status. (0:off, 1:on)
//  int  gotoxy(int x_position, int y_position) : Move cursor to new position.
//  int  wherex(void)                           : Get x-coordinate of the cursor location.
//  int  wherey(void)                           : Get y-coordinate of the cursor location.
//  int  wherexy(int *column, int *row)         : Get x-coordinate and y-coordinate of the cursor location.
//
//  SYNTECH INFORMATION CO., LTD.
//
//***************************************************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    int  ix, iy;

    clr_scr ();
    gotoxy (3, 1);
    puts ("LCD CURSOR TEST");

    SetCursor (1);

    gotoxy (3, 3);
    if (GetCursor())
        puts ("GET CURSOR ON.");
    else
        puts ("GET CURSOR OFF.");

    ix = wherex ();
    iy = wherey ();

    gotoxy (0, 5);
    printf ("WHEREX:%d, WHEREY:%d", ix,iy);

    wherexy (&ix, &iy);

    gotoxy (0, 6);
    printf ("WHEREXY: x=%d, y=%d", ix, iy);

    while (getchar() != KEY_ESC);
    }
//-------------------------------------------------------------------------//
